/*
	Month Calendar - A Monthly Calendar with Week Numbers
	Copyright © 2005-2008 Harry Whitfield

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA  02110-1301  USA
	
	Month Calendar - version 2.4
	12 March, 2008
	Copyright © 2005-2008 Harry Whitfield
	mailto:g6auc@arrl.net
*/

		// memoWindow.js globals
		
		var left  = true;
		var right = false;
		var upper = true;
		var lower = false;
		
		var magnification =  2;		// magnification factor with lens button
				
		var border        = 10;		// border size was 10
					
		var wDelta 		  = 30;		// was 30
		var hDelta		  = 40;		// was 40
				
		var oversizeMag   = Number(preferences.oversizePref.value) + 1;
		
		var enlargedFlag = false;
		
		var memoTitle = "";
		
		var halfWinWidth;
		var halfWinHeight;
		var halfWidth;
		var halfHeight;
		
		var frameOpacity;
		var newRotation;
		
		var speakMemoToggle = false;
		
		var anchorX = 0;
		var anchorY = 0;
		
		//var section = 0;
		
		//eprint("section: " + (section++)); 

		function max(a, b) { if (a > b) { return a; } return b; }

		//eprint("section: " + (section++)); 

		function min(a, b) { if (a < b) { return a; } return b; }

		//eprint("section: " + (section++)); 

		//function stringWidth(string, fontname, fontstyle, fontsize)

		function XstringWidth(string, fontname, fontsize)	// by Perry Clarke 6 May 2004
		{
			var tmpText = new Text();
			var width;
			
			tmpText.opacity = 0;
			tmpText.font = fontname;
			tmpText.size = fontsize;
			tmpText.data = string;
			
			//updateNow();				// temporary patch K 1.6
		
			width = tmpText.width;
			tmpText = null;
			return width;
		}

		//eprint("section: " + (section++)); 

		function saveAnchorPoint()
		{
			var anchorPref = preferences.anchorPref.value;

			switch (anchorPref)
			{
				case "None":
					anchorX = memo_info.hOffset;
					anchorY = memo_info.vOffset;
					break;
					
				case "Top Left of Screen":
					anchorX = memo_info.hOffset;
					anchorY = memo_info.vOffset;
					break;
				
				case "Top Right of Screen":
					anchorX = memo_info.hOffset + memo_info.width;
					anchorY = memo_info.vOffset;
					break;
					
				case "Bottom Left of Screen":
					anchorX = memo_info.hOffset;
					anchorY = memo_info.vOffset + memo_info.height;
					break;
					
				case "Bottom Right of Screen":
					anchorX = memo_info.hOffset + memo_info.width;
					anchorY = memo_info.vOffset + memo_info.height;
					break;
					
				case "Center of Screen":
					anchorX = memo_info.hOffset + (memo_info.width  >> 1);
					anchorY = memo_info.vOffset + (memo_info.height >> 1);
					break;

				case "Top Left of Memo Window":
					anchorX = memo_info.hOffset;
					anchorY = memo_info.vOffset;
					break;
				
				case "Top Right of Memo Window":
					anchorX = memo_info.hOffset + memo_info.width;
					anchorY = memo_info.vOffset;
					break;
					
				case "Bottom Left of Memo Window":
					anchorX = memo_info.hOffset;
					anchorY = memo_info.vOffset + memo_info.height;
					break;
					
				case "Bottom Right of Memo Window":
					anchorX = memo_info.hOffset + memo_info.width;
					anchorY = memo_info.vOffset + memo_info.height;
					break;

				case "Center of Memo Window":
					anchorX = memo_info.hOffset + (memo_info.width  >> 1);
					anchorY = memo_info.vOffset + (memo_info.height >> 1);
					break;
			}
			preferences.anchorXPref.value = String(anchorX);
			preferences.anchorYPref.value = String(anchorY);
		}

		function anchorWindow(winWidth, winHeight)
		{
			var anchorPref = preferences.anchorPref.value;
			if (anchorPref != "None")
			{
				switch (anchorPref)
				{
					case "Top Left of Screen":
						memo_info.hOffset = screen.availLeft;
						memo_info.vOffset = screen.availTop;
						break;
					
					case "Top Right of Screen":
						memo_info.hOffset = screen.availLeft + screen.availWidth  - winWidth;
						memo_info.vOffset = screen.availTop;
						break;
						
					case "Bottom Left of Screen":
						memo_info.hOffset = screen.availLeft;
						memo_info.vOffset = screen.availTop  + screen.availHeight - winHeight;
						break;
						
					case "Bottom Right of Screen":
						memo_info.hOffset = screen.availLeft + screen.availWidth  - winWidth;
						memo_info.vOffset = screen.availTop  + screen.availHeight - winHeight;
						break;
						
					case "Center of Screen":
						memo_info.hOffset = screen.availLeft + ((screen.availWidth  - winWidth ) >> 1);
						memo_info.vOffset = screen.availTop  + ((screen.availHeight - winHeight) >> 1);
						break;

					case "Top Left of Memo Window":
						memo_info.hOffset = anchorX;
						memo_info.vOffset = anchorY;
						break;
					
					case "Top Right of Memo Window":
						memo_info.hOffset = anchorX - winWidth;
						memo_info.vOffset = anchorY;
						break;
						
					case "Bottom Left of Memo Window":
						memo_info.hOffset = anchorX;
						memo_info.vOffset = anchorY - winHeight;
						break;
						
					case "Bottom Right of Memo Window":
						memo_info.hOffset = anchorX - winWidth;
						memo_info.vOffset = anchorY - winHeight;
						break;

					case "Center of Memo Window":
						memo_info.hOffset = anchorX - (winWidth  >> 1);
						memo_info.vOffset = anchorY - (winHeight >> 1);
					break;
				}
			}
		}

		function set(object, left, x, upper, y, w, h)
		{
			if (systemPlatform != "macintosh")	// until windows version of K is fixed
			{
				object.hOffset = halfWinWidth  + (left  ? - halfWidth  + x : - 0 + halfWidth  + x);
				object.vOffset = halfWinHeight + (upper ? - halfHeight + y : - 0 + halfHeight + y);
			}
			else
			{
				object.hOffset = halfWinWidth;
				object.vOffset = halfWinHeight;
				object.hRegistrationPoint = (left  ? - x + halfWidth  : - halfWidth  - x);
				object.vRegistrationPoint = (upper ? - y + halfHeight : - halfHeight - y);  
				object.rotation = newRotation;
			}
			
			if (w !== 0) { object.width  = w; }
			if (h !== 0) { object.height = h; }
			object.opacity = frameOpacity;
		}

		//eprint("section: " + (section++)); 

		function reSize(big)
		{
			//eprint('-------------reSize--------------------');
			
			var newWidth    = preferences.widthPref.value;
			var newHeight   = preferences.heightPref.value;
				newRotation = Number(preferences.rotationPref.value);
			var focus       = (close.opacity !== 0);
			
			//eprint("reSize:image.src=" + image.src);
			//eprint("reSize:image.srcWidth=" + image.srcWidth);
			//eprint("reSize:image.srcHeight=" + image.srcHeight);

			var originalWidth  = Number(image.srcWidth);	// original width
			var originalHeight = Number(image.srcHeight);	// original height

			var width;
			var height;
			var aspectRatio;

			if ((newWidth !== "") && (newHeight !== ""))		// user specified width and height
			{
				width  = Number(newWidth);
				height = Number(newHeight);
				aspectRatio = Number(width / height);
			}
			else if ((newWidth === "") && (newHeight === ""))	// user specified neither width nor height
			{
				width  = Number(originalWidth);
				height = Number(originalHeight);
				aspectRatio = Number(width / height);
			}
			else if ((newWidth !== "") && (newHeight === ""))	// user specified width only
			{
				width  = Number(newWidth);
				aspectRatio = Number(originalWidth / originalHeight);
				height = Math.round(width / aspectRatio);
			}
			else if ((newWidth === "") && (newHeight !== ""))	// user specified height only
			{
				height = Number(newHeight);
				aspectRatio = Number(originalWidth / originalHeight);
				width = Math.round(height * aspectRatio);
			}
			else { return; }

			if (preferences.aspectRatioPref.value != "0")
			{
				aspectRatio = Number(4 / 3);
				height = Number(width / aspectRatio);
			}

			var minW = 136;
			var minH =  32;
			
			if (width < minW) 
			{
				width  = minW;
				height = Math.round(width / aspectRatio);
			}
			
			if (height < minH) 
			{
				height = minH;
				width = Math.round(height * aspectRatio);
			}

			if (big)	// apply magnification factor
			{
				//eprint('magnification=' + magnification);
				
				width  = Math.round( magnification * width);
				height = Math.round( magnification * height);
			}

			var pi = Math.PI;
			var theta = pi * newRotation / 180;
			
			var fullWidth  = wDelta - 0 + width;  //eprint('fullWidth= ' + fullWidth);
			var fullHeight = hDelta - 0 + height; //eprint('fullHeight=' + fullHeight);
			
			var rotWidth  = Math.round(fullWidth*Math.abs(Math.cos(theta)) + fullHeight*Math.abs(Math.sin(theta)));
			var rotHeight = Math.round(fullWidth*Math.abs(Math.sin(theta)) + fullHeight*Math.abs(Math.cos(theta)));
			
			//eprint('rotWidth= '  + rotWidth);
			//eprint('rotHeight= ' + rotHeight);

			var maxWidth  = oversizeMag*screen.availWidth  - border - border - 10;
			if (preferences.maxWidthPref.value !== "") { maxWidth = min(maxWidth, preferences.maxWidthPref.value); }

			var maxHeight = oversizeMag*screen.availHeight - border - border - 30;
			if (preferences.maxHeightPref.value !== "") { maxHeight = min(maxHeight, preferences.maxHeightPref.value); }
			
			maxWidth  = Math.round(maxWidth  * fullWidth  / rotWidth );
			maxHeight = Math.round(maxHeight * fullHeight / rotHeight);
			
			//eprint('maxWidth= '  + maxWidth);
			//eprint('maxHeight= ' + maxHeight);

			if (width > maxWidth) 
			{
				width  = maxWidth;
				height = Math.round(width / aspectRatio);
			}
			
			if (height > maxHeight) 
			{
				height = maxHeight;
				width = Math.round(height * aspectRatio);
			}

			width  = width  + (width  % 2); //eprint('width= ' + width);
			height = height + (height % 2); //eprint('height=' + height);
			
			halfWidth  = width  >> 1;  //eprint('halfWidth= ' + halfWidth);
			halfHeight = height >> 1;  //eprint('halfHeight=' + halfHeight);

			fullWidth  = wDelta - 0 + width;  //eprint('fullWidth= ' + fullWidth);
			fullHeight = hDelta - 0 + height; //eprint('fullHeight=' + fullHeight);

			var winWidth  = Math.round(fullWidth*Math.abs(Math.cos(theta)) + fullHeight*Math.abs(Math.sin(theta)));
			var winHeight = Math.round(fullWidth*Math.abs(Math.sin(theta)) + fullHeight*Math.abs(Math.cos(theta)));
			
			winWidth  = winWidth  + (winWidth  % 2) + 10;
			winHeight = winHeight + (winHeight % 2) + 30;
			
			memo_info.width  = winWidth;	//eprint('memo_info.width= ' + memo_info.width);
			memo_info.height = winHeight;	//eprint('memo_info.height=' + memo_info.height);
			
			anchorWindow(winWidth, winHeight);

			halfWinWidth  = winWidth  >> 1;	//eprint('halfWinWidth= ' + halfWinWidth);
			halfWinHeight = winHeight >> 1;	//eprint('halfWinHeight=' + halfWinHeight);

			frameOpacity = 0;
			
			if ((systemPlatform == "macintosh") &&	((newRotation % 90) === 0) ) { frameOpacity = 255; }
			if ((systemPlatform != "macintosh") &&	( newRotation       === 0) ) { frameOpacity = 255; }
			
			if (preferences.framePref.value != "0") { frameOpacity = 0; }

			image.hOffset = halfWinWidth;
			image.vOffset = halfWinHeight;
           	image.hRegistrationPoint = halfWidth;
           	image.vRegistrationPoint = halfHeight -1 + 9;
           	image.width = width;
           	image.height = height;
			image.rotation = newRotation;
			
       		memo.width = width;
			memo.height = height;
			memo.hOffset = halfWinWidth - halfWidth;
			memo.vOffset = halfWinHeight - halfHeight - 8;

			set(upperLeft,   left, -13, upper, -19,          0,           0);
			set(top,         left,   8, upper, -19, width - 15,           0);
			set(upperRight,  right, -7, upper, -19,          0,           0);
			
			set(leftSide,    left, -13, upper,   3,          0, height - 18);
			set(rightSide,   right, -7, upper,   3,          0, height - 18);
 			
 			set(lowerLeft,   left, -13, lower, -15,          0,           0);
 			set(bottom,      left,   8, lower, -15, width - 15,           0);
			set(lowerRight,  right, -7, lower, -15,          0,           0);
			
  			if (! focus) { lowerLeft.opacity = 0; }
			if (! focus) { bottom.opacity = 0; }
          	if (! focus) { lowerRight.opacity = 0; }

   			set(lowerLeftSmall,   left, -13, lower, -15,          0,      0);
			set(bottomSmall,      left,   8, lower, -14, width - 15,      0);
 			set(lowerRightSmall,  right, -7, lower, -15,          0,      0);
			
  			if (focus) { lowerLeftSmall.opacity = 0;} 
			if (focus) { bottomSmall.opacity = 0; }
           	if (focus) { lowerRightSmall.opacity = 0; }

			if ((systemPlatform == "macintosh") || (newRotation === 0))
			{
	          	set(add,    left,    8, lower, -9, 0, 0);
	          	add.opacity = 0;	// add not used in this widget
				//if (focus) add.opacity = 255;
				
	          	set(open,   left,    8, lower, -9, 0, 0);
				open.opacity = 0;
				if (focus) { open.opacity = 255; }
				
	          	set(wrench, left,   28, lower, -9, 0, 0);
				wrench.opacity = 0;
				if (focus) { wrench.opacity = 255; }

	          	set(back, left,   48, lower, -9, 0, 0);
				back.opacity = 0;
				if (focus) { back.opacity = 255; }

	          	set(forward,  right, -68, lower, -9, 0, 0);
				forward.opacity = 0;
				if (focus) { forward.opacity = 255; }
				
	          	set(close,  right, -48, lower, -9, 0, 0);
				close.opacity = 0;
				if (focus) { close.opacity = 255; }
				
	         	set(spawn,  right, -28, lower, -9, 0, 0);
	 			spawn.opacity = 0;
	 			if (focus) { spawn.opacity = 255; }
 			}
 			else	// temporary code until windows version of K is fixed
 			{
				add.hOffset = halfWinWidth - 80;
				add.vOffset = winHeight - 16;
				add.opacity = 0;	// add not used in this widget
				
				open.hOffset = halfWinWidth - 60;
				open.vOffset = winHeight - 16;
				open.opacity = 0;
				if (focus) { open.opacity = 255; }
				
				wrench.hOffset = halfWinWidth - 40;
				wrench.vOffset = winHeight - 16;
				wrench.opacity = 0;
				if (focus) { wrench.opacity = 255; }
				
				back.hOffset = halfWinWidth - 20;
				back.vOffset = winHeight - 16;
				back.opacity = 0;
				if (focus) { back.opacity = 255; }

				forward.hOffset = halfWinWidth;
				forward.vOffset = winHeight - 16;
				forward.opacity = 0;
				if (focus) { forward.opacity = 255; }

				close.hOffset = halfWinWidth + 20;
				close.vOffset = winHeight - 16;
				close.opacity = 0;
				if (focus) {close.opacity = 255; }
				
				spawn.hOffset = halfWinWidth + 40;
				spawn.vOffset = winHeight - 16;
	 			spawn.opacity = 0;
	 			if (focus) { spawn.opacity = 255; }
  			}

 			//set(reflectionLeft,   left,   2, lower,  -8,          0,           0);
 			//set(reflectionMiddle, left,   8, lower,  -8, width - 14,           0);
			//set(reflectionRight,  right, -6, lower,  -8,          0,           0);
			
  			//if (! focus) reflectionLeft.opacity = 0;
			//if (! focus) reflectionMiddle.opacity = 0;
          	//if (! focus) reflectionRight.opacity = 0;

			statusShadow.hOffset = halfWinWidth;
			statusShadow.vOffset = winHeight - 33;
          	statusShadow.opacity = 0;
          	if ((focus) && (newRotation === 0)) { statusShadow.opacity = 255; }

			status.hOffset = halfWinWidth;
			status.vOffset = winHeight - 34;
          	status.opacity = 0;
          	if ((focus) && (newRotation === 0)) { status.opacity = 255; }

			//function stringWidth(string, fontname, fontstyle, fontsize)

			var sWidth = stringWidth(memoTitle, "Futura Medium", "", 9);
            var bWidth = width - 142;
            if (sWidth <= bWidth)
            {
            	status.data = statusShadow.data = memoTitle;
            }
            else
            {
            	status.data = statusShadow.data = "";
            }
            //focusWidget();
		}

		function showMemoButtons()
		{
		  var i;
		  
		  //var showFrame = ((preferences.rotationPref.value % 90) === 0);
			
			var showFrame =  ((systemPlatform == "macintosh") && ((newRotation % 90) === 0)) ||
						     ((systemPlatform != "macintosh") && ( newRotation       === 0));
			
			if (preferences.framePref.value != "0") { showFrame = false; }

			var showName  =  (Number(preferences.rotationPref.value) === 0);
			
			if (close.opacity === 0)
			{
				for (i = 31; i < 256; i += 32)
				{
					if (showFrame) 
					{
						lowerRight.opacity = lowerLeft.opacity = bottom.opacity = i;
						//reflectionLeft.opacity = reflectionMiddle.opacity = reflectionRight.opacity = i;
						lowerRightSmall.opacity = lowerLeftSmall.opacity = bottomSmall.opacity = 255 - i;
					}
					if (showName) { status.opacity = statusShadow.opacity = i; }
					open.opacity = close.opacity = spawn.opacity = wrench.opacity = back.opacity = forward.opacity = i;
					if (i < 255) { sleep(10); }
				}
			}
		}

		//eprint("section: " + (section++)); 

		function hideMemoButtons()
		{
		  var i;
		  
		  //var showFrame = ((preferences.rotationPref.value % 90) === 0);
			
			var showFrame =  ((systemPlatform == "macintosh") && ((newRotation % 90) === 0)) ||
						     ((systemPlatform != "macintosh") && ( newRotation       === 0));

			if (preferences.framePref.value != "0") { showFrame = false; }

			var showName  =  (Number(preferences.rotationPref.value) === 0);

			if (close.opacity !== 0)
			{
				for (i = 224; i >= 0; i -= 32)
				{
					if (showFrame) 
					{
						lowerRight.opacity = lowerLeft.opacity = bottom.opacity = i;
						//reflectionLeft.opacity = reflectionMiddle.opacity = reflectionRight.opacity = i;
						lowerRightSmall.opacity = lowerLeftSmall.opacity = bottomSmall.opacity = 255 - i;
					}
					if (showName) { status.opacity = statusShadow.opacity = i; }
					open.opacity = close.opacity = spawn.opacity = wrench.opacity = back.opacity = forward.opacity = i;
					if (i > 0) { sleep(10); }
				}
			}
		}

		//eprint("section: " + (section++)); 

		function cardinalOf(num)
		{
			var tens = Math.floor(num / 10);
			var units = num % 10;
		
			switch(num)	// num 0..59
			{
				case  0 : return "zero";
				case  1 : return "one";
				case  2 : return "two";
				case  3 : return "three";
				case  4 : return "four";
				case  5 : return "five";
				case  6 : return "six";
				case  7 : return "seven";
				case  8 : return "eight";
				case  9 : return "nine";
				case 10 : return "ten";
				case 11 : return "eleven";
				case 12 : return "twelve";
				case 13 : return "thirteen";
				case 14 : return "fourteen";
				case 15 : return "fifteen";
				case 16 : return "sixteen";
				case 17 : return "seventeen";
				case 18 : return "eighteen";
				case 19 : return "nineteen";
				case 20 : return "twenty";
				case 30 : return "thirty";
				case 40 : return "forty";
				case 50 : return "fifty";
				case 60 : return "sixty";
				case 70 : return "seventy";
				case 80 : return "eighty";
				case 90 : return "ninety";
				
				default : 	if (num > 20 )
								{ return cardinalOf(10*tens) + "-" + cardinalOf(units); }
			}
		}
		
		//eprint("section: " + (section++)); 

		function speakMemo()
		{
			if (speakMemoToggle) { speakMemoToggle = false; speechTimer.ticking = false; speak(""); return; }
			
			var cps = 12;	// characters per second
			var maxTime = Number(preferences.maxSpeechTime.value);
			var data = memo.data.replace(/\<\<\w*\=[^\;\n\<\>]*?(\;\w*\=[^\;\n\<\>]*?)*\>\>\n?/g, "");	// remove embeded commands

			var n = data.length;
			var secs = Math.floor(n / cps);
			
			if (n > 0)
			{
				if (n < 10*cps)
				{
					speakMemoToggle = true;
					speechTimer.interval = secs; speechTimer.ticking = true;
					speak(data);
				}
				else if ((maxTime <= 100) && (n < maxTime*cps))
				{
					speakMemoToggle = true;
					speechTimer.interval = secs; speechTimer.ticking = true;
					speak('This will take about ' + cardinalOf(secs) + ' seconds.\n\n' + data);
				}
				else if (maxTime <= 100)
				{
					speak('The text is too long.');
				}
				else
				{
					speakMemoToggle = true;
					speak(data);
				}
			} else { speak('There is no text.'); }
		}

		//eprint("section: " + (section++)); 

		function toggleSize()
		{
			if (system.event.altKey) { speakMemo(); return; }

			saveAnchorPoint();
			
			enlargedFlag = ! enlargedFlag;
			reSize(enlargedFlag);
		}

		//eprint("section: " + (section++)); 

		function setFrameColor(color)
		{
			upperLeft.colorize=color;
			top.colorize=color;
			upperRight.colorize=color;
			rightSide.colorize=color;
			leftSide.colorize=color;
			lowerRight.colorize=color;
			bottom.colorize=color;
			lowerLeft.colorize=color;
			lowerRightSmall.colorize=color;
			bottomSmall.colorize=color;
			lowerLeftSmall.colorize=color;
		}

		//eprint("section: " + (section++)); 

		function updateMemoPrefs()
		{
			var minW = 136;
			var minH =  32;
			
			oversizeMag   = Number(preferences.oversizePref.value) + 1;
			
			var maxW = oversizeMag*screen.availWidth;
			var maxH = oversizeMag*screen.availHeight;

			var width = preferences.widthPref.value;
			if (width !== "")
			{
				width = parseInt(width, 10);
				if (isNaN(width)) { width = minW; }
				if (width < minW) { width = minW; }
				if (width > maxW) { width = maxW; }
				preferences.widthPref.value = width;
			}
			
			var height = preferences.heightPref.value;
			if (height !== "")
			{
				height = parseInt(height, 10);
				if (isNaN(height)) { height = minH; }
				if (height < minH) { height = minH; }
				if (height > maxH) { height = maxH; }
				preferences.heightPref.value = height;
			}
			
			var maxWidth = preferences.maxWidthPref.value;
			if (maxWidth !== "")
			{
				maxWidth = parseInt(maxWidth, 10);
				if (isNaN(maxWidth)) { maxWidth = ""; }
				else
				{
					if (maxWidth < minW) { maxWidth = minW; }
					if (maxWidth > maxW) { maxWidth = maxW; }
				}
				preferences.maxWidthPref.value = maxWidth;
			}
			
			var maxHeight = preferences.maxHeightPref.value;
			if (maxHeight !== "")
			{
				maxHeight = parseInt(maxHeight, 10);
				if (isNaN(maxHeight)) { maxHeight = ""; }
				else
				{
					if (maxHeight < minH) { maxHeight = minH; }
					if (maxHeight > maxH) { maxHeight = maxH; }
				}
				preferences.maxHeightPref.value = maxHeight;
			}
			
			var rotation = parseInt(preferences.rotationPref.value, 10);
			if (isNaN(rotation)) { rotation = 0; }
			if (rotation ==  360) { preferences.framePref.value = "0"; }
			if (rotation == -360) { preferences.framePref.value = "1"; }
			if (rotation >  359) { rotation = 0; }
			if (rotation < -359) { rotation = 0; }
			preferences.rotationPref.value = rotation;

			savePreferences();
			
			setFrameColor(preferences.frameColor.value);

			magnification = Number(preferences.memoScalePref.value)/ 100;
			//eprint('magnification=' + magnification);
			
			anchorX = Number(preferences.anchorXPref.value);
			anchorY = Number(preferences.anchorYPref.value);

			memo.color = preferences.memoTextColor.value;
			memo.bgColor = preferences.memoTextBgColor.value;

			suppressUpdates();
			reSize(enlargedFlag);
			resumeUpdates();
		}
